/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.render.InventoryOverlayScreen;
import fi.dy.masa.malilib.test.ConfigTestEnum;
import fi.dy.masa.malilib.test.TestInventoryOverlayHandler;
import fi.dy.masa.malilib.test.gui.GuiTestFileBrowser;
import fi.dy.masa.malilib.test.gui.GuiTestList;
import fi.dy.masa.malilib.test.gui.GuiTestPosEditor;
import fi.dy.masa.malilib.util.time.TimeTestExample;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class TestInputHandler
implements IKeybindProvider {
    private static final TestInputHandler INSTANCE = new TestInputHandler();
    private final Callbacks callback = new Callbacks();

    private TestInputHandler() {
        this.init();
    }

    public static TestInputHandler getInstance() {
        return INSTANCE;
    }

    public Callbacks getCallback() {
        return this.callback;
    }

    public void init() {
        MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind().setCallback(this.callback);
        MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY_TOGGLE.getKeybind().setCallback(this.callback);
        MaLiLibConfigs.Test.TEST_GUI_KEYBIND.getKeybind().setCallback(this.callback);
        MaLiLibConfigs.Test.TEST_GUI_EDITOR_KEYBIND.getKeybind().setCallback(this.callback);
        MaLiLibConfigs.Test.TEST_GUI_FILE_BROWSER_KEYBIND.getKeybind().setCallback(this.callback);
        MaLiLibConfigs.Test.TEST_RUN_DATETIME_TEST.getKeybind().setCallback(this.callback);
    }

    @Override
    public void addKeysToMap(IKeybindManager manager) {
        for (IHotkey hotkey : MaLiLibConfigs.Test.HOTKEY_LIST) {
            manager.addKeybindToMap(hotkey.getKeybind());
        }
        for (ConfigTestEnum toggle : ConfigTestEnum.values()) {
            manager.addKeybindToMap(toggle.getKeybind());
        }
    }

    @Override
    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("MaLiLib", "malilib.hotkeys.category.test_hotkeys", MaLiLibConfigs.Test.HOTKEY_LIST);
        manager.addHotkeysForCategory("MaLiLib", "malilib.hotkeys.category.test_enum_hotkeys", (List<? extends IHotkey>)ImmutableList.copyOf((Object[])ConfigTestEnum.values()));
    }

    public static class Callbacks
    implements IHotkeyCallback {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onKeyAction(KeyAction action, IKeybind key) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return false;
            }
            if (key == MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind()) {
                return true;
            }
            if (key == MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY_TOGGLE.getKeybind()) {
                if (mc.screen instanceof InventoryOverlayScreen) {
                    mc.setScreen(null);
                    return false;
                }
                if (!MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getBooleanValue()) return false;
                if (!MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind().isKeybindHeld()) return false;
                TestInventoryOverlayHandler.getInstance().refreshInventoryOverlay(mc, true, true);
                return true;
            }
            if (key == MaLiLibConfigs.Test.TEST_GUI_KEYBIND.getKeybind()) {
                System.out.printf("testGuiKeybind Callback Action: [%s] (Cancel = false)\n", action.getStringValue());
                GuiBase.openGui(new GuiTestList());
                return false;
            }
            if (key == MaLiLibConfigs.Test.TEST_GUI_EDITOR_KEYBIND.getKeybind()) {
                System.out.printf("testGuiEditorKeybind Callback Action: [%s] (Cancel = false)\n", action.getStringValue());
                GuiBase.openGui(new GuiTestPosEditor());
                return false;
            }
            if (key == MaLiLibConfigs.Test.TEST_GUI_FILE_BROWSER_KEYBIND.getKeybind()) {
                System.out.printf("testGuiFileBrowserKeybind Callback Action: [%s] (Cancel = false)\n", action.getStringValue());
                GuiBase.openGui(new GuiTestFileBrowser());
                return false;
            }
            if (key != MaLiLibConfigs.Test.TEST_RUN_DATETIME_TEST.getKeybind()) return false;
            mc.gui.getChat().addMessage(Component.nullToEmpty((String)TimeTestExample.runTimeDateTest()));
            mc.gui.getChat().addMessage(Component.nullToEmpty((String)TimeTestExample.runDurationTest()));
            return true;
        }
    }
}

